BEGIN {
	use TiVo::Trace;
	$TiVo::Trace::file_handle 	= \*STDOUT;
	$TiVo::Trace::file_handle_flags = TRACE_ALL;
}

use TiVo::OSD::Buffer;
use TiVo::OSD::CS22;
use Getopt::Long;

use strict;



my $optv = {};

GetOptions($optv, 'noindex', 'palette=s', 'scale=s');
$optv->{scale} ||=1;

my $osd_hw 	= TiVo::OSD::CS22->new;
my $osd 	= TiVo::OSD::Buffer->new;

my $first_idx 	= shift(@ARGV);
my $last_idx 	= shift(@ARGV);

if($optv->{palette}) {
	my $palette	= $osd->set_palette;
	$palette->load($optv->{palette});
	$osd_hw->write_palette($osd);
}	

print "Finished Loading... ",scalar localtime,"\n";

$osd_hw->clear;

print "Finished Clearing... ",scalar localtime,"\n";

my $id = $osd->add_region(0,0,719,479);
$osd->set_curr_region($id);

print "Finished Adding Region... ",scalar localtime,"\n";

my $x_offset 	= 75;
my $x_size 	= 64 * $optv->{scale};
my $x_spacer 	= 4  * $optv->{scale};

my $y_offset 	= 60;
my $y_size 	= 40 * $optv->{scale};
my $y_spacer 	= 4  * $optv->{scale};

$osd->{bg_color} = 0x0D;
$osd->{fg_color} = 0xBF;
$osd->fill(0x0D);

my $swatch = 0;
foreach my $color ($first_idx .. $last_idx) {
	my $horizontal_patch 	= $swatch % (8 / $optv->{scale});
	my $vertical_patch 	= int($swatch / (8 / $optv->{scale}));

	$osd->set_bounding_box(
		$x_offset + ($horizontal_patch * ($x_size + $x_spacer)),
		$y_offset + ($vertical_patch * ($y_size + $y_spacer)),
		$x_offset + (($horizontal_patch + 1) * $x_size) + ($horizontal_patch * $x_spacer),
		$y_offset + (($vertical_patch + 1)* $y_size) + ($vertical_patch * $y_spacer)
	);
	$osd->fill($color);

	unless($optv->{noindex}) {
		$osd->add_string(sprintf("%02X", $color));
	}

	$swatch++;
}

print "Finished Filling Buffer... ",scalar localtime,"\n";

$osd_hw->write_osd($osd);

print "Finished Writing to CS22... ",scalar localtime,"\n";

