use Tk;
use TiVo::Util;
use strict;

my $base_name 	= shift @ARGV;
my $file 	= "$base_name.gif";

my $main 	= MainWindow->new();
my $photo 	= $main->Photo(-file => $file);

my $height 	= $photo->height();
my $width 	= $photo->width();

my $index   	= 0;
my @palette 	= ();
my @image_data 	= ();
my %color2index = ();

print "$width, $height\n";

for(my $y=0; $y<$height; $y++)
{
	for(my $x=0; $x<$width; $x++)
	{
		my ($Y, $Cb, $Cr) = RGB_to_YCbCr($photo->get($x,$y));

		my $key = pack_palette_entry($Y, $Cb, $Cr);
		if (!exists($color2index{$key}))
		{
			$color2index{$key} = $index++;
			push @palette, $key;
		}

		push @image_data, $color2index{$key};
	}
}

#Pack the palette...
my $packed_palette = pack("n*", @palette);

#Pack the data...
my $packed_w_h = pack("NN", $width, $height);
my $packed_image = pack("C*", @image_data);

#header for the .osd file format
# id_string, version, color_count, width, height
my $osd_header = pack("a8NNNN", 'TiVo_OSD', 0, scalar(@palette), $width, $height) | ("\0"x64);

open(DF, ">$base_name.osd");
binmode(DF);
print DF $osd_header, $packed_palette, $packed_image;
close DF;
