########################################################
#### TiVo::YAC::Sender                              ####
########################################################

package TiVo::YAC::Sender;

use TiVo::Trace;
use Socket;
use Exporter;
use strict;

use vars ('$PACKAGE', '$VERSION', '@ISA', '@EXPORT');

$PACKAGE 	= "TiVo::YAC::Sender";
$VERSION 	= "1.00.00";
@ISA 		= qw(Exporter);
@EXPORT 	= qw(yac_send);

Trace(TRACE_LOAD, "Module Load: $PACKAGE $VERSION");

sub yac_send {
	my $message 	= shift;
	my $host 	= shift || '127.0.0.1';

	Trace(TRACE_DEBUG, "$PACKAGE $host $message");

	$message 	=~ s/\\n/\n/g;

	socket(SOCK,AF_INET,SOCK_STREAM,6) || die("Unable to open socket: $!");

	my $dest_addr = sockaddr_in(10629,inet_aton($host));

	connect(SOCK,$dest_addr) || die("Unable to connect socket: $!");

	print SOCK $message;

	close(SOCK);
}

return(1);
