########################################################
#### TiVo::WebHandler::YAC                	    ####
########################################################

package TiVo::WebHandler::YAC;

use TiVo::Trace;
use TiVo::YAC::Sender;
use TiVo::WebHandler::Util;

use Socket;
use Data::Dumper;

use strict;
use vars ('$PACKAGE', '$VERSION', '$CHILD');

$PACKAGE = "TiVo::WebHandler::YAC";
$VERSION = "1.00.00";

Trace(TRACE_LOAD, "Module Load: $PACKAGE $VERSION");

sub Register {
	my $class = shift;
	my $httpd = shift;

	my $reghash = {
		ForLocation 	=> "yac",
		InternalName	=> $PACKAGE,
		InternalVersion	=> $VERSION,
		DisplayName 	=> "Yet Another Caller ID",
		EntryPoint	=> \&TiVo::WebHandler::YAC::HandlerEntry
	};
	
	$httpd->RegisterHandler($reghash);
}

sub HandlerEntry {
	my $session 	= shift;
	my $request 	= shift;
	my %args 	= (@_);

	if($args{send}) {
		yac_send($args{message}, $args{host});

		my $body;
		$body .= "<H1>YAC Message Sent</H1>\n";
		$body .= "<H2>Host: $args{host}</H2>\n";
		$body .= "<H2>Message: $args{message}</H2>\n";

		send_page_200($session, "YAC Message Sent", $body);
	}
	else {
		my $body;
		$body .= "<H1>Send a YAC Message</H1>\n";
		$body .= "<FORM METHOD=GET ACTION=\"/yac\">\n";
		$body .= "<TABLE>\n";
		$body .= "<TR><TD>Host IP</TD><TD><INPUT NAME=\"host\" value=\"127.0.0.1\"></TD>\n";
		$body .= "<TR><TD>Message</TD><TD><INPUT NAME=\"message\"></TD>\n";
		$body .= "</TABLE>\n";
		$body .= "<INPUT TYPE=HIDDEN NAME=\"send\" value=\"send\">\n";
		$body .= "<BR><INPUT TYPE=SUBMIT>\n";
		$body .= "<BR><INPUT TYPE=RESET>\n";
		$body .= "</FORM>\n";

		send_page_200($session, "Send a YAC message", $body);
	}
	
}

return(1);
