package TiVo::WebHandler::Util;

use TiVo::Trace;
use Exporter;

use strict;
use vars ('$PACKAGE', '$VERSION', '@ISA', '@EXPORT');

@ISA 	= qw(Exporter);
@EXPORT = qw(
	get_style_sheet
	mime_type
	send_status_200
	send_status_404
	send_status_500
	send_page_200
	send_page_404
	send_page_500
	uri_escape
	uri_unescape
);

$PACKAGE = "TiVo::WebHandler::Util";
$VERSION = "1.00.00";

Trace(TRACE_LOAD, "Module Load: $PACKAGE $VERSION");

my %mime_types = (
	'txt'	=> 'text/plain',
	'text'	=> 'text/plain',
	'pm'	=> 'text/plain',
	'pl'	=> 'text/plain',
	'htm'	=> 'text/html',
	'html'	=> 'text/html',

	'png'	=> 'image/png',
	'gif'	=> 'image/gif',
	'jpg'	=> 'image/jpeg',

	'osd'	=> 'image/x-osd-combo',
	'osdp'	=> 'image/x-osd-palette',
	'osdi'	=> 'image/x-osd-image',
);

sub mime_type {
	my $fn 	= shift;
	my @fn 	= split(/\\|\/|\./, $fn);
	my $ext = lc $fn[-1];
	return($mime_types{$ext} || 'application/octet-stream');
}

sub _get_style_sheet {
	my $css;
	$css .= "<style type=\"text/css\">\n";
	$css .= "<!--\n";

	$css .= "body {color: black; background: #FFFFFF; font-family: arial, helvetica, sans-serif;}\n";
	$css .= "h1, h2 {color: blue; font-style: bold;}\n";
	$css .= "table {spacing: 0px; border: 2px solid blue; empty-cells: show;}\n";
	$css .= "td {border: 1px solid black;}\n";

	$css .= "-->\n";
	$css .= "</style>\n";

	return($css);
}

sub get_style_sheet {
	return "<link rel=\"stylesheet\" href=\"/file/themes/default.css\">\n";
}

sub send_status_200 {
	my $session = shift;
	print $session "HTTP/1.1 200 OK\n";
	print $session "Server: TiVo-Perl\n";
}

sub send_status_404 {
	my $session = shift;
	print $session "HTTP/1.1 404 Not found\n";
	print $session "Server: TiVo-Perl\n";
}

sub send_status_500 {
	my $session = shift;
	print $session "HTTP/1.1 500 Internal server error\n";
	print $session "Server: TiVo-Perl\n";
}

sub send_page_404 {
	my $session = shift;
	my $message = shift;

	send_status_404($session);
	print $session "Content-type: text/html\n\n";
	print $session "<HTML>\n";
	print $session "<HEAD><TITLE>404 Not Found</TITLE>" . get_style_sheet() . "</HEAD>\n";
	print $session "<BODY>\n";
	print $session "<H1>404 Not Found</H1>\n";
	print $session "<H2>$message</H2>\n";
	print $session "</BODY>\n";
	print $session "</HTML>\n";
}

sub send_page_500 {
	my $session = shift;
	my $message = shift;

	send_status_500($session);
	print $session "Content-type: text/html\n\n";
	print $session "<HTML>\n";
	print $session "<HEAD><TITLE>500 Server Error</TITLE>" . get_style_sheet() . "</HEAD>\n";
	print $session "<BODY>\n";
	print $session "<H1>500 Server Error</H1>\n";
	print $session "<H2>A fatal error was trapped: $@</H2>\n";
	print $session "</BODY>\n";
	print $session "</HTML>\n";
}

sub send_page_200 {
	my $session 	= shift;
	my $title 	= shift;
	my $body 	= shift;

	send_status_200($session);
	print $session "Content-type: text/html\n\n";
	print $session "<HTML>\n";
	print $session "<HEAD><TITLE>$title</TITLE>" . get_style_sheet() . "</HEAD>\n";
	print $session "<BODY>\n";
	print $session "<IMG SRC=\"/file/images/tivoperl-banner.gif\">\n";
	print $session "$body\n";
	print $session "</BODY>\n";
	print $session "</HTML>\n";
}

####
#### Shamelessly stolen from URI::Escape
####
my %uri_escapes;
for (0..255) {
	$uri_escapes{chr($_)} = sprintf("%%%02X", $_);
}

my %uri_subst;

sub uri_escape {
	my($text, $patn) = @_;
	return undef unless defined $text;
	if (defined $patn){
		unless (exists  $uri_subst{$patn}) {
			# Because we can't compile the regex we fake it with a cached sub
			(my $tmp = $patn) =~ s,/,\\/,g;
			eval "\$uri_subst{\$patn} = sub {\$_[0] =~ s/([$tmp])/\$uri_escapes{\$1}/g; }";
			Carp::croak("uri_escape: $@") if $@;
		}
		&{$uri_subst{$patn}}($text);
	}
	else {
		# Default unsafe characters.  RFC 2732 ^(uric - reserved)
		$text =~ s/([^A-Za-z0-9\-_.!~*'()])/$uri_escapes{$1}/g;
	}
	return($text);
}

sub uri_unescape {
	my $str = shift;
	$str 	=~ s/%([0-9A-Fa-f]{2})/chr(hex($1))/eg;
	$str 	=~ s/\+/ /g;
	return($str);
}

return(1);