########################################################
#### TiVo::WebHandler::FileDownload                 ####
########################################################

package TiVo::WebHandler::SysInfo;

use TiVo::Trace;
use TiVo::SysInfo;
use TiVo::WebHandler::Util;

use Socket;
use Data::Dumper;

use strict;
use vars ('$PACKAGE', '$VERSION', '$CHILD');

$PACKAGE = "TiVo::WebHandler::SysInfo";
$VERSION = "1.00.00";

Trace(TRACE_LOAD, "Module Load: $PACKAGE $VERSION");

sub Register {
	my $class = shift;
	my $httpd = shift;

	my $reghash = {
		ForLocation 	=> "sysinfo",
		InternalName	=> $PACKAGE,
		InternalVersion	=> $VERSION,
		DisplayName 	=> "System Information Display",
		EntryPoint	=> \&TiVo::WebHandler::SysInfo::HandlerEntry
	};
	
	$httpd->RegisterHandler($reghash);
}

sub HandlerEntry {
	my $session 	= shift;
	my $request 	= shift;
	my %args 	= (@_);

	my $therm 	= GetInternalTemperature;
	my $cpu 	= GetCPUInformation;
	my $mem 	= GetMemoryInformation;
	my $net 	= GetNetworkInformation;

	my $body;

	$body .="<H1>TiVo System Information</H1>\n";

	$body .="<TABLE>\n";

	$body .="<TR><TD COLSPAN=2><H2>Environmental</H2></TD></TR>\n";
	$body .="<TR><TD><B>Internal Temperature:</B></TD><TD>$therm->{TempC}C ($therm->{TempF}F)</TD></TR>\n";

	$body .="<TR><TD COLSPAN=2><H2>CPU</H2></TD></TR>\n";
	$body .="<TR><TD><B>CPU Type:</B></TD><TD>$cpu->{cpu}</TD></TR>\n";
	$body .="<TR><TD><B>CPU Speed:</B></TD><TD>$cpu->{clock}</TD></TR>\n";
	$body .="<TR><TD><B>CPU Load:</B></TD><TD>$cpu->{loadavg}</TD></TR>\n";

	$body .="<TR><TD COLSPAN=2><H2>Memory</H2></TD></TR>\n";
	$body .="<TR><TD><B>Total RAM:</B></TD><TD>$mem->{MemTotal} KB</TD></TR>\n";
	$body .="<TR><TD><B>Free RAM:</B></TD><TD>$mem->{MemFree} KB</TD></TR>\n";
	$body .="<TR><TD><B>Total Swap:</B></TD><TD>$mem->{SwapTotal} KB</TD></TR>\n";
	$body .="<TR><TD><B>Free Swap:</B></TD><TD>$mem->{SwapFree} KB</TD></TR>\n";

	$body .="<TR><TD COLSPAN=2><H2>Network</H2></TD></TR>\n";
	$body .="<TR><TD><B>MAC Address:</B></TD><TD>$net->{MACAddress}</TD></TR>\n";
	$body .="<TR><TD><B>IP Address:</B></TD><TD>$net->{IPAddress}</TD></TR>\n";
	$body .="<TR><TD><B>Subnet Mask:</B></TD><TD>$net->{SubnetMask}</TD></TR>\n";
	$body .="<TR><TD><B>Default Gateway:</B></TD><TD>$net->{DefaultGateway}</TD></TR>\n";

	$body .="</TABLE>\n";

	send_page_200($session, "TiVo System Information", $body)

}

return(1);
