########################################################
#### TiVo::WebHandler::FileDownload                 ####
########################################################

package TiVo::WebHandler::FileDownload;

use TiVo::Trace;
use TiVo::WebHandler::Util;

use Socket;
use Data::Dumper;

use strict;
use vars ('$PACKAGE', '$VERSION', '$ROOTPATH');

$PACKAGE = "TiVo::WebHandler::FileDownload";
$VERSION = "1.00.00";

Trace(TRACE_LOAD, "Module Load: $PACKAGE $VERSION");

sub SetRootPath {
	my $class 	= shift;
	$ROOTPATH	= shift;
}

sub Register {
	my $class = shift;
	my $httpd = shift;

	my $reghash = {
		ForLocation 	=> "file",
		InternalName	=> $PACKAGE,
		InternalVersion	=> $VERSION,
		DisplayName 	=> "File Download Handler",
		EntryPoint	=> \&TiVo::WebHandler::FileDownload::HandlerEntry
	};
	
	$httpd->RegisterHandler($reghash);
}

sub HandlerEntry {
	my $session 	= shift;
	my $request 	= shift;
	my %args 	= (@_);

	my @request	= split(/\//, $request);
	shift(@request); shift(@request);
	my $file_path 	= join('/', $ROOTPATH, @request);
	if(-f $file_path) {
		send_status_200($session);
		print $session "Content-type: " . mime_type($file_path) . "\n\n";

		local *F_IN;
		open(F_IN, $file_path) || Panic("open() failed: $!");
		binmode(F_IN);
		my $size = (stat $file_path)[7];
		my $buffer;
		sysread(F_IN, $buffer, $size);
		close(F_IN);

		print $session $buffer;
	}
	else {
		send_page_404($session, "The file &quot;$file_path&quot; does not exist.");
	}
}

return(1);
