########################################################
#### TiVo::WebHandler::Default                      ####
########################################################

package TiVo::WebHandler::Default;

use TiVo::Trace;
use TiVo::SysInfo;
use TiVo::WebHandler::Util;

use Socket;
use Data::Dumper;

use strict;
use vars ('$PACKAGE', '$VERSION');

$PACKAGE = "TiVo::WebHandler::Default";
$VERSION = "1.00.00";

Trace(TRACE_LOAD, "Module Load: $PACKAGE $VERSION");

sub Register {
	my $class = shift;
	my $httpd = shift;

	my $reghash = {
		ForLocation 	=> "default",
		InternalName	=> $PACKAGE,
		InternalVersion	=> $VERSION,
		DisplayName 	=> "Default Handler",
		EntryPoint	=> \&TiVo::WebHandler::Default::HandlerEntry
	};
	
	$httpd->RegisterHandler($reghash);
}

sub HandlerEntry {
	my $session 	= shift;
	my $request 	= shift;
	my %args 	= (@_);

	my $body;
	$body .= "<H1>Welcome to TiVo::Perl!</H1>\n";
	$body .= "<UL>\n";
	$body .= "<LI><A HREF=\"/sysinfo\">View System Information</A></LI>\n";
	$body .= "<LI><A HREF=\"/yac\">Send a message via YAC</A></LI>\n";
	$body .= "</UL>\n";

	send_page_200($session, "Welcome to TiVo::Perl", $body);
}

return(1);
