package TiVo::Trace;

use Socket;
use Exporter;

use strict;
use vars (
	'$PACKAGE', '$VERSION',
	'@ISA', '@EXPORT',
	'$file_handle', '$file_handle_flags',
	'$sock_handle', '$sock_handle_flags',
);

@ISA = qw(Exporter);

@EXPORT = qw(
	Trace
	Panic
	TRACE_FATAL
	TRACE_ERROR
	TRACE_WARN
	TRACE_INFO
	TRACE_DEBUG
	TRACE_LOAD
	TRACE_ALL
	TRACE_STANDARD
);

$PACKAGE	= "TiVo::Trace";
$VERSION	= "1.00.00";

sub Trace {
	my $flag = shift;
	my $text = join(' ', @_);

	my @time 	= localtime;
	$time[5] 	+= 1900;
	$time[4] 	+= 1;

	my $msg	= sprintf("%06d %04d/%02d/%02d %02d:%02d:%02d %s\n", $flag, @time[5,4,3,2,1,0], $_[0]);

	if($file_handle && (($flag & $file_handle_flags) == $flag)) {
		print $file_handle $msg;
	}

	if($sock_handle && (($flag & $sock_handle_flags) == $flag)) {
		syswrite($sock_handle, $msg, length($msg));
	}

	if($flag == TRACE_FATAL()) {
		die($text);
	}
}

sub ConnectSocket {
	my %args = (@_);
	my $host 	= $args{Host} || "127.0.0.1";
	my $stream 	= $args{Stream};
	my $port 	= $args{Port} || 515;

	local *SOCK;
	socket(SOCK,AF_INET,SOCK_STREAM,6)
		|| die("Unable to open socket: $!");
	my $dest_addr = sockaddr_in($port,inet_aton($host));
	connect(SOCK,$dest_addr)
		|| die("Unable to connect socket: $!");

	$sock_handle = *SOCK;

	my $hello 	= "SET_STREAM $stream\n";
	my $bytes 	= syswrite($sock_handle, $hello, length($hello));
}

sub Panic {
	my $text = shift;
	my ($package, $filename, $line) = caller();
	Trace(TRACE_FATAL(), "$text (in $package, line $line of $filename)");
}

#### Constants for the various trace levels
sub TRACE_FATAL 	() { 2 ** 1  }
sub TRACE_ERROR 	() { 2 ** 2  }
sub TRACE_WARN 		() { 2 ** 3  }
sub TRACE_INFO 		() { 2 ** 4  }
sub TRACE_DEBUG 		() { 2 ** 5  }
sub TRACE_LOAD		() { 2 ** 6  }

sub TRACE_ALL		() { (2 ** 7) - 1 }

sub TRACE_STANDARD	() { return(TRACE_FATAL|TRACE_ERROR|TRACE_WARN|TRACE_INFO) }

return(1);

