package TiVo::SysInfo;

use TiVo::Trace;
use Exporter;

use strict;
use vars ('$PACKAGE', '$VERSION', '@ISA', '@EXPORT');

@ISA 	= qw(Exporter);
@EXPORT = qw(
	GetInternalTemperature
	GetCPUInformation
	GetMemoryInformation
	GetNetworkInformation
);

$PACKAGE = "TiVo::SysInfo";
$VERSION = "1.00.00";

Trace(TRACE_LOAD, "Module Load: $PACKAGE $VERSION");

sub GetInternalTemperature {
	my $rdata = {};
	($rdata->{TempC}) 	= _slurp_proc_file('therm');
	$rdata->{TempC} 	=~ s/\D//g;
	$rdata->{TempF} 	= int(((9/5)*$rdata->{TempC}) + 32.5);
	return($rdata)	
}

sub GetMemoryInformation {
	my $rdata = {};
	my @meminfo = _slurp_proc_file('meminfo');
	shift(@meminfo); shift(@meminfo); shift(@meminfo);
	foreach my $line (@meminfo) {
		my @line = split(/:/, $line);
		$line[0] =~ s/\s//g;
		$line[1] =~ s/\D//g;
		$rdata->{$line[0]} = $line[1];
	}
	return($rdata);	
}

sub GetCPUInformation {
	my $rdata = {};

	my @cpuinfo = _slurp_proc_file('cpuinfo');
	foreach my $line (@cpuinfo) {
		my @line = split(/:/, $line);
		$line[0] =~ s/\s//g;
		next unless $line[0] =~ m/^cpu|clock$/i;
		$line[1] =~ s/^\s+//g;
		$line[1] =~ s/\s+$//g;
		$rdata->{$line[0]} = $line[1];
	}

	my($load) = _slurp_proc_file('loadavg');
	my @load = split(/\s+/, $load);
	$rdata->{loadavg} = $load[0];

	return($rdata);	
}

sub GetNetworkInformation {
	my $rdata 	= {};

	my $ifconfig 		= `ifconfig -v eth0`;
	$ifconfig 		=~ m/HWaddr ([0-9a-fA-F:]+)/;
	$rdata->{MACAddress} 	= $1;
	$ifconfig		=~ m/inet addr:([0-9.]+)/;
	$rdata->{IPAddress} 	= $1;
	$ifconfig		=~ m/Mask:([0-9.]+)/;
	$rdata->{SubnetMask} 	= $1;

	my @route = `route -n`;
	shift(@route);
	foreach my $line (@route) {
		my @line = split(/\s+/, $line);
		if($line[0] eq "0.0.0.0") {
			$rdata->{DefaultGateway} = $line[1];
		}
	}
	
	return($rdata);
}

sub _slurp_proc_file {
	my $filename = shift;
	my @procdata;

	local *F_IN;
	open(F_IN, "/proc/$filename")
		|| Panic("Unable to open /proc/$filename");
	while(my $line = <F_IN>) {
		chomp($line);
		push(@procdata, $line);
	}
	close(F_IN);

	return(@procdata);
}

return(1);