package TiVo::OSD::Emulator;

use strict;
use vars('@PALETTE');

use Tk;
use TiVo::Util;

@PALETTE = 
(
	'yellow',
	'red',
	'orange',
	'blue',
	'green',
	'purple'
);

$PALETTE[0xBF] = 'white';
$PALETTE[0x0D] = 'black';

#################### PRIVATE METHODS ######################3

sub _pad_8
{
	my $element = shift;

	my $start = round_down_8($element->{'start'});
	my $start_pad = $element->{'start'} - $start;
	my $end = round_up_8($element->{'start'} + $element->{'len'});
	my $end_pad = $end - ($element->{'start'} + $element->{'len'});

	my $new_element = 
	{
		'start' => $start,
		'len' => $element->{'len'} + $start_pad + $end_pad,
		'buf' => "\0"x$start_pad . $element->{'buf'} . "\0"x$end_pad
	};

	return $new_element;
}

#################### PUBLIC METHODS ########################

sub new
{
	my $self = {};
	my $class = shift;

	$self->{'size'} = [720,480];
	my ($x, $y) = @{$self->{'size'}};

	#Create the main window
	my $main = MainWindow->new
	(
		-relief => 'sunken',
		-borderwidth => 2,
		-width => $x+4,
		-height => $y+4
	);
	$main->resizable(0,0);

	my $photo = $main->Photo
	(
		-width => $x, 
		-height => $y
	);

	my $label = $main->Label
	(
		-image => $photo,
		-borderwidth => 0
	)->place(-x => 0, -y => 0);

	$photo->put('blue', -to => 0, 0, $x, $y);

	$self->{'main'} = $main;
	$self->{'photo'} = $photo;

	return bless $self, $class;
}

sub write_osd
{
	my $self = shift;
	my $osd_buffer = shift;

	my $photo = $self->{'photo'};
	my ($size_x, $size_y) = @{$self->{'size'}};
	my $element;
	foreach $element (@{$osd_buffer->{'buffer'}})
	{
		$element = _pad_8($element);
		
		die() if ($element->{'start'} % 8);
		die() if ($element->{'len'} % 8);

		my $x = $element->{'start'} % $size_x;
		my $y = int($element->{'start'} / $size_x);
	
		my @data = unpack("C*", $element->{'buf'});

		my $curr_x = $x;
		my $curr_y = $y;
		my @line;
		foreach my $val (@data)
		{
			push @line, $PALETTE[$val];
			
			$curr_x++;
			if ($curr_x >= $size_x)
			{
				$x = $curr_x = 0;
				$y = ++$curr_y;
				$photo->put([\@line], -to => $x, $y);
				@line = ();
			}
		}

		$photo->put([\@line], -to => $x, $y);
	}
}

sub write_palette
{
	my $self = shift;
	my $osd_buffer = shift;

	my $palette = $osd_buffer->{'palette'};
	my @palette_data = unpack("n*", $palette->{'data'});

	my $i = 0;
	my $rgb_str = "";
	foreach my $entry (@palette_data)
	{
		if ($entry != 0)
		{
			my @YCbCr = unpack_palette_entry($entry);
			my @RGB = YCbCr_to_RGB(@YCbCr);

			$rgb_str = sprintf("#%02X%02X%02X", @RGB);
		}
		else
		{
			$rgb_str = 'black';
		}

		@PALETTE[$i++] = $rgb_str;
	}
}

sub clear
{
	my $self = shift;
	my ($size_x, $size_y) = @{$self->{'size'}};
	my $osd_buffer;

	push @{$osd_buffer->{'buffer'}}, {'start' => 0, 'len' => ($size_x*$size_y), 'buf' => "\0"x($size_x*$size_y)};

	write_osd($self, $osd_buffer);
}

sub EmulatorLoop
{
	MainLoop();
}

return(1);
