package TiVo::OSD::CS22;

use TiVo::Trace;
use TiVo::Util;
use Fcntl;

use strict;
use vars ('$PACKAGE', '$VERSION');

$PACKAGE = "TiVo::OSD::CS22";
$VERSION = "1.00.00";

Trace(TRACE_LOAD, "Module Load: $PACKAGE $VERSION");

#################### PRIVATE FUNCTIONS ######################3

sub _pad_8
{
	my $element = shift;

	my $start = round_down_8($element->{start});
	my $start_pad = $element->{start} - $start;
	my $end = round_up_8($element->{start} + $element->{len});
	my $end_pad = $end - ($element->{start} + $element->{len});

	my $new_element = 
	{
		start => $start,
		len => $element->{len} + $start_pad + $end_pad,
		buf => "\0"x$start_pad . $element->{buf} . "\0"x$end_pad
	};

	return $new_element;
}

#################### PUBLIC METHODS ########################

sub new
{
	my $self = {};
	my $class = shift;

	bless($self, $class);

	$self->{device} 	= "/dev/mpeg0v";
	$self->{ioctl} 		= 0x403;
	$self->{palette_offset} = 8;
	$self->{data_offset} 	= 8+512;
	$self->{size} 		= [720,480];

	#The hardware control header
	#This is 8 bytes and defines a single 256 color region
	$self->{'header'} = "";		#currently not implemented

	#Executing this system command will reinit
	#the on screen display
	$self->{'init_osd_cmd'} = "osdwriter";

	return($self);
}

sub write_osd
{
	my $self = shift;
	my $osd_buffer = shift;

	open(MPEG, "+<$self->{device}");

	foreach my $nelement (@{$osd_buffer->{buffer}})
	{
		my $element = _pad_8($nelement);
		my $data = pack("IIP", $self->{data_offset}+$element->{start}, $element->{len}, $element->{buf});
		ioctl(MPEG, $self->{ioctl}, $data);
	}

	close(MPEG);
}

sub write_palette
{
	my $self = shift;
	my $osd_buffer = shift;

	my $palette = $osd_buffer->{palette};
	my $length = $palette->{colors} * $palette->{bytes_per_color};

	open(MPEG, "+<$self->{device}");

	my $data = pack("IIP", $self->{palette_offset}, $length, $palette->{data});
	ioctl(MPEG, $self->{ioctl}, $data);

	close(MPEG);
}

sub clear
{
	my $self = shift;
	my ($size_x, $size_y) = @{$self->{size}};
	my $osd_buffer;

	push @{$osd_buffer->{buffer}}, {start => 0, len => ($size_x*$size_y), buf => "\0"x($size_x*$size_y)};

	$self->write_osd($osd_buffer);
}

sub init
{
	my $self = shift;
	system($self->{'init_osd_cmd'});
}

return(1);


