package TiVo::MFS::Object;

use Carp;
use TiVo::Trace;
use TiVo::MFS;
use TiVo::MfsUtil;

use strict;
use vars ('$PACKAGE', '$VERSION');

$PACKAGE = "TiVo::MFS::Object";
$VERSION = "1.00.00";

Trace(TRACE_LOAD, "Module Load: $PACKAGE $VERSION");

#########################################################

sub new
{
	my $class = shift;
	my $path = shift;

	chop($path);	#"$path" should always have a trailing "/" to be chopped off.

	my $mfs_util = $TiVo::MFS::MFS_UTIL;

	my $find_info = $mfs_util->find($path) or return undef;
	my $self = $mfs_util->dumpobj($find_info->{fsid});

	bless $self, $class;
	return $self;
}

1;