package TiVo::MFS::File;

use Carp;
use TiVo::Trace;
use TiVo::MFS;
use TiVo::MfsUtil;

use strict;
use vars ('$PACKAGE', '$VERSION');

$PACKAGE = "TiVo::MFS::File";
$VERSION = "1.00.00";

Trace(TRACE_LOAD, "Module Load: $PACKAGE $VERSION");

#########################################################

sub new
{
	my $class = shift;
	my $path = shift;

	my %tied_hash;
	tie %tied_hash, $class, $path;

	return \%tied_hash;
}

sub TIEHASH
{
	my $class = shift;
	my $path = shift;
	my $self = {};

	my $mfs_util = $TiVo::MFS::MFS_UTIL;

	$self->{path} = $path;
	
	my $info = $mfs_util->find($path);
	return undef if (!defined($info));

	my $fsid = $info->{fsid};
	if ($info->{type} eq "tyStream")
	{
		my $stream_size = $mfs_util->streamsize($fsid);
		$info = {(%$info), (%$stream_size)} if (defined($stream_size));
	}
	else
	{
		my $size = $mfs_util->size($fsid);
		$info->{size} = $size if (defined($size));
	}

	$info->{'moddate'} = $mfs_util->moddate($fsid);

	$self->{info} = $info;
	
	bless $self, $class;
	return $self;
}

sub FETCH
{
	my $self = shift;
	my $key = shift;

	if ($key =~ /^\//)
	{
		return TiVo::MFS::open($self->{path} . $key);
	}
	else
	{
		return $self->{info}->{$key};
	}
}

sub EXISTS
{
	my $self = shift;
	my $key = shift;

	return exists($self->{info}->{$key});
}

sub FIRSTKEY 
{
	my $self = shift;
	my $a = keys %{$self->{info}};		# reset each() iterator
	return each %{$self->{info}};
}  

sub NEXTKEY 
{
	my $self = shift;
	return each %{$self->{info}};
}

sub DESTROY {}

################## Unsupported functionality ###################

sub STORE
{
	croak("Writing to MFS unsupported!\n");
}

sub DELETE
{
	croak("Writing to MFS unsupported!\n");
}

sub CLEAR
{
	croak("Writing to MFS unsupported!\n");
}

1;