package TiVo::MFS::Directory;

use Carp;
use TiVo::Trace;
use TiVo::MFS;
use TiVo::MfsUtil;

use strict;
use vars ('$PACKAGE', '$VERSION');

$PACKAGE = "TiVo::MFS::Directory";
$VERSION = "1.00.00";

Trace(TRACE_LOAD, "Module Load: $PACKAGE $VERSION");

#########################################################

sub new
{
	my $class = shift;
	my $path = shift;

	my %tied_hash;
	tie %tied_hash, $class, $path;

	return \%tied_hash;
}

sub TIEHASH
{
	my $class = shift;
	my $path = shift;
	my $self = {};

	my $mfs_util = $TiVo::MFS::MFS_UTIL;

	$self->{path} = $path;

	my @files = $mfs_util->scan($path);
	my %file_hash = map { $_->{name} => {type => $_->{type}, fsid => $_->{fsid}} } @files;
	$self->{list} = \%file_hash;

	bless $self, $class;

	return $self;
}

sub FETCH
{
	my $self = shift;
	my $path = shift;

	return TiVo::MFS::open($self->{path} . $path);
}

sub EXISTS
{
	my $self = shift;
	my $file = shift;

	return exists($self->{list}->{$file});
}

sub FIRSTKEY 
{
	my $self = shift;
	my $a = keys %{$self->{list}};		# reset each() iterator
	return each %{$self->{list}};
}  

sub NEXTKEY 
{
	my $self = shift;
	return each %{$self->{list}};
}

sub DESTROY {}

################## Unsupported functionality ###################

sub STORE
{
	croak("Writing to MFS unsupported!\n");
}

sub DELETE
{
	croak("Writing to MFS unsupported!\n");
}

sub CLEAR
{
	croak("Writing to MFS unsupported!\n");
}

1;