package TiVo::MFS;

use TiVo::Trace;
use TiVo::MFS::Directory;
use TiVo::MFS::Object;
use TiVo::MFS::File;

use TiVo::MfsUtil;

use strict;
use vars ('$PACKAGE', '$VERSION', '$MFS_UTIL', '$DBG');

$PACKAGE = "TiVo::MFS";
$VERSION = "1.00.00";

$DBG = 0;

Trace(TRACE_LOAD, "Module Load: $PACKAGE $VERSION");

#########################################################

# The "open" function takes the full path to an
# MFS file (possibly with a "/" appended)
# It simply calls the new() method for the
# appropriate underlying class and returns
# the resultant object.
sub open
{
	my $path = shift;

	if (!defined($MFS_UTIL))
	{
		$MFS_UTIL = new TiVo::MfsUtil('tivodev:667');
		print STDERR "Created new MfsUtil object.\n";
	}

	return new TiVo::MFS::Directory($path) if ($path eq "/");

	if ($path =~ /\/$/)
	{
		my $mfs_file = $path;
		chop($mfs_file);

		my $file_info = $MFS_UTIL->find($mfs_file) or return undef;
		if ($file_info->{type} eq 'tyDir')
		{
			print "Make a dir: $path\n" if $DBG;
			return new TiVo::MFS::Directory($path);
		}
		else
		{
			print "Make an object: $path\n" if $DBG;
			return new TiVo::MFS::Object($path);
		}
	}
	else
	{
		print "Make a file: $path\n" if $DBG;
		return new TiVo::MFS::File($path);
	}
}

1;
			

		